"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.multitenancyRoutes = multitenancyRoutes;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _constants = require("../../../utils/constants");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2016 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

function multitenancyRoutes({
  router,
  searchGuardBackend,
  config,
  sessionStorageFactory,
  logger
}) {
  const debugEnabled = config.get('searchguard.multitenancy.debug');
  const isMtEnabledInBE = async () => {
    const {
      kibana_mt_enabled
    } = await searchGuardBackend.getKibanaInfoWithInternalUser();
    config.set('searchguard.multitenancy.enabled', kibana_mt_enabled);
    return kibana_mt_enabled;
  };
  router.post({
    path: `${_constants.API_ROOT}/multitenancy/tenant`,
    validate: {
      body: _configSchema.schema.object({
        tenant: _configSchema.schema.string(),
        username: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const isMTEnabled = await isMtEnabledInBE();
      if (!isMTEnabled) {
        return response.notFound();
      }
      const selectedTenant = request.body.tenant;
      const cookie = (await sessionStorageFactory.asScoped(request).get()) || {};
      cookie.tenant = selectedTenant;
      sessionStorageFactory.asScoped(request).set(cookie);
      if (debugEnabled) {
        logger.info(`tenant_POST: ${selectedTenant}`);
      }
      const rawRequest = (0, _coreHttpRouterServerInternal.ensureRawRequest)(request);
      (0, _lodash.assign)(rawRequest.headers, {
        sgtenant: selectedTenant
      });
      return response.ok({
        body: selectedTenant
      });
    } catch (error) {
      return response.internalError({
        body: error
      });
    }
  });
  router.get({
    path: `${_constants.API_ROOT}/multitenancy/tenant`,
    validate: false
  }, async (context, request, response) => {
    try {
      const isMTEnabled = await isMtEnabledInBE();
      if (!isMTEnabled) {
        return response.notFound();
      }
      let selectedTenant = undefined;
      const resolvedContext = await context.resolve(['searchGuard']);
      sessionStorageFactory = await resolvedContext.searchGuard.sessionStorageFactory;
      const cookie = await sessionStorageFactory.asScoped(request).get();
      if (cookie) {
        selectedTenant = cookie.tenant;
      }
      if (debugEnabled) {
        logger.info(`tenant_GET: ${selectedTenant}`);
      }
      return response.ok({
        body: selectedTenant
      });
    } catch (error) {}
    return response.notFound();
  });
  router.get({
    path: `${_constants.API_ROOT}/multitenancy/info`,
    validate: false
  }, async (context, request, response) => {
    const isMTEnabled = await isMtEnabledInBE();
    if (!isMTEnabled) {
      return response.notFound();
    }
    const mtinfo = await searchGuardBackend.multitenancyinfo(request.headers);
    return response.ok({
      body: mtinfo
    });
  });
} //end module
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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